//
// Copyright (C) 2019, NinjaTrader LLC <www.ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//
#region Using declarations
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Windows.Media;
using System.Xml.Serialization;
#endregion

//This namespace holds Indicators in this folder and is required. Do not change it. 
namespace NinjaTrader.NinjaScript.Indicators.Porschay
{
	/// <summary>
	/// The Disparity Index measures the difference between the price and an exponential moving average. A value greater could suggest bullish momentum, while a value less than zero could suggest bearish momentum.
	/// </summary>
	public class PriscillianRead : Indicator
	{
		protected override void OnStateChange()
		{
			if (State == State.SetDefaults)
			{
				Description					= NinjaTrader.Custom.Resource.NinjaScriptIndicatorDescriptionDisparityIndex;
				Name						= "PriscillianRead";
				IsOverlay					= false;
				IsSuspendedWhileInactive	= true;
				Period 						= 25;
				
				AddPlot(Brushes.DodgerBlue,   NinjaTrader.Custom.Resource.NinjaScriptIndicatorDisparityLine);
				AddLine(Brushes.DarkGray, 0,  NinjaTrader.Custom.Resource.NinjaScriptIndicatorZeroLine);
			}
		}

		protected override void OnBarUpdate()
		{
			if (Close[0] <= 0)
				return;
			
			DisparityLine[0] = 100 * (Close[0] - EMA(Close, Period)[0]) / Close[0];
			if (CurrentBar > 1) {
PlotBrushes[0][0] = DisparityLine[1] < DisparityLine[0] ? Brushes.Green : Brushes.Red;
}
		}	
		
		[Range(1, int.MaxValue), NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "Period", GroupName = "NinjaScriptParameters", Order = 0)]
		public int Period { get; set; }

		[Browsable(false)]
		[XmlIgnore]
		public Series<double> DisparityLine { get { return Values[0]; } }
	}
}

#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		private Porschay.PriscillianRead[] cachePriscillianRead;
		public Porschay.PriscillianRead PriscillianRead(int period)
		{
			return PriscillianRead(Input, period);
		}

		public Porschay.PriscillianRead PriscillianRead(ISeries<double> input, int period)
		{
			if (cachePriscillianRead != null)
				for (int idx = 0; idx < cachePriscillianRead.Length; idx++)
					if (cachePriscillianRead[idx] != null && cachePriscillianRead[idx].Period == period && cachePriscillianRead[idx].EqualsInput(input))
						return cachePriscillianRead[idx];
			return CacheIndicator<Porschay.PriscillianRead>(new Porschay.PriscillianRead(){ Period = period }, input, ref cachePriscillianRead);
		}
	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		public Indicators.Porschay.PriscillianRead PriscillianRead(int period)
		{
			return indicator.PriscillianRead(Input, period);
		}

		public Indicators.Porschay.PriscillianRead PriscillianRead(ISeries<double> input , int period)
		{
			return indicator.PriscillianRead(input, period);
		}
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		public Indicators.Porschay.PriscillianRead PriscillianRead(int period)
		{
			return indicator.PriscillianRead(Input, period);
		}

		public Indicators.Porschay.PriscillianRead PriscillianRead(ISeries<double> input , int period)
		{
			return indicator.PriscillianRead(input, period);
		}
	}
}

#endregion
